//
//  BPPGServer.h
//  BPAdmin
//
//  Created by Michael Clark on 13/06/09.
//  Copyright 2009 Marketcircle, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <MCPostgresPersistence/MCPGServer.h>


// PW Conveniences - Named kinda silly on purpose!!
extern NSString* BPMainWord(MCPGServer* server); // Returns the super (Main) user password
extern NSString* BPBasicWord(MCPGServer* server); // Returns the basic user password


@class MCDaemonKeeper;
@class MCPModel;
@class BPServerDatabaseConnection, BIDatabaseObjectContext;
@class MCSQLiteContext;

@interface BPPGServer : MCPGServer {

	MCDaemonKeeper *daemonKeeper;
    
    MCPModel*   clientModel;
    MCPModel*   serverModel;
	MCPModel*   touchModel;
	
	BPServerDatabaseConnection *bpConnection;
	BIDatabaseObjectContext *bpObjCtxt;
		
	BOOL BI3RestoreInProgress;
	
	unsigned long long totalRows;
	unsigned long long notifIncrement;
	unsigned long long rowsProcessed;
    
    MCSQLiteContext *localSQLiteContext;
}

@property (retain, nonatomic, readwrite) MCDaemonKeeper *daemonKeeper;

- (NSString*)personalDatabaseFile;

#pragma mark -
#pragma mark Shared Database
+ (id)sharedBillingsProObjectContext DEPRECATED_IN_MAC_OS_X_VERSION_10_6_AND_LATER;
+ (void)closeSharedBillingsProObjectContextConnection DEPRECATED_IN_MAC_OS_X_VERSION_10_6_AND_LATER;

/*!
 Returns a new (not shared), autoreleased database connection; class methods use the -sharedServer instance
 */
- (BPServerDatabaseConnection *)connectionForDatabaseNamed:(NSString *)dbName;
+ (BPServerDatabaseConnection *)connectionForDatabaseNamed:(NSString *)dbName;
- (BPServerDatabaseConnection *)createDatabaseConnection;
+ (BPServerDatabaseConnection *)createDatabaseConnection;

/*!
 Returns a new, autoreleased objectContext which owns its databaseConnection
 */
- (BIDatabaseObjectContext *)objectContextForDatabase:(NSString *)dbName;
+ (BIDatabaseObjectContext *)objectContextForDatabase:(NSString *)dbName;
- (BIDatabaseObjectContext *)createObjectContext;
+ (BIDatabaseObjectContext *)createObjectContext;


#pragma mark -
#pragma mark Database Management
- (NSDictionary*)mainDatabase;
- (BOOL)doesBillingsProDatabaseExist;

- (BOOL)createBillingsProDatabaseIncludeDefaultData: (BOOL)includeData error: (NSError**)error; // Calls below method with the canned BP database name as BP is a single DB app for now
- (BOOL)createBillingsProDatabaseNamed: (NSString*)aName includeDefaultData: (BOOL)includeData error: (NSError**)error; // Calls below method with the default database path from settings
- (BOOL)createBillingsProDatabaseNamed:(NSString *)aName databasePath:(NSString *)path includeDefaultData:(BOOL)includeData error:(NSError **)error; // Used by migrator - a DB simply with the schema setup - no data
// You can pass in either a MCPGDatabase or MCSQLiteContext for aDatabase
- (BOOL)installChangeLogTriggersInDatabase: (id)aDatabase error: (NSError**)error;
// DROPs change_log triggers for cache value fields so they do not get included in the syncs. Refer to BP-966 for more details.
- (BOOL)removeCacheValueTriggersInDatabase:(id)aDatabase error:(NSError **)error;

// Support for informing caller whether we restored from a Billings 3 database
- (BOOL)restoreDBNamed:(NSString*)aName fromBackupAtPath:(NSString*)aPath isBillings3:(BOOL *)isBI3 autoBackupExisting:(BOOL)flag error:(NSError**)error;

/*!
 A cover for saveReplicaAccessDetails because of the sillyness of it being saved as plist.
 */
- (void)saveDefaultReplicaDetailsWithUsername:(NSString *)uname remoteURL:(NSString *)urlString uuid:(NSString *)aUUID;


- (NSString *)rootStageDirectoryPath;

#pragma mark -
#pragma mark Server Preferences

// should probably be moved to superclass
- (void)setUserDefaultsBool:(BOOL)flag forKey:(NSString *)aKey;
- (BOOL)userDefaultsBoolForKey:(NSString *)aKey;

- (BOOL)didFirstRun;
- (void)setDidFirstRun:(BOOL)flag;

- (BOOL)enableUPnP;
- (void)setEnableUPnP:(BOOL)flag;

- (BOOL)externalAccessEnabled;
- (void)setExternalAccessEnabled:(BOOL)flag;

- (BOOL)touchWasTurnedOn;
- (void)setTouchWasTurnedOn:(BOOL)flag;

- (BOOL)enableHTTPDebug;
- (void)setEnableHTTPDebug:(BOOL)flag;

- (NSInteger)httpChosenPortNumber;
- (void)setHTTPChosenPortNumber:(NSInteger)aNum;

- (BOOL)hideInactiveClients;
- (void)setHideInactiveClients:(BOOL)flag;

-(NSString *)touchDatabaseName;
- (void)setTouchDatabaseName:(NSString *)aString;

- (NSString *)eventTrackerDatabasePath;

// For trial checking - First Use Date (FUD)
- (NSDate*)fud;
- (void)setFud: (NSDate*)aDate;


#pragma mark -
#pragma mark Accessors
- (MCPModel*)clientModel;
- (MCPModel*)serverModel;
- (MCPModel *)touchModel;
- (BPServerDatabaseConnection *)bpConnection;
- (void)setBpConnection:(BPServerDatabaseConnection *)aBpConnection;
- (BIDatabaseObjectContext *)bpObjCtxt;
- (void)setBpObjCtxt:(BIDatabaseObjectContext *)aBpObjCtxt;

- (NSString *)cloudID;

@end
